module Main where

import Runner
import System.Environment(getArgs, getProgName)
import System.Exit(die)
import Text.Read(readMaybe)

main :: IO ()
main = do
   args <- getArgs
   case args of
      [filename, wordsLength, numberOfGames] -> do
         let getWordsLength = case readMaybe wordsLength of
               Just l -> l
               _ -> error "wordsLength must be an integer"
             getNumberOfGames = case readMaybe numberOfGames of
               Just l -> l
               _ -> error "numberOfGames must be an integer"
         results <- simulateGames filename getWordsLength getNumberOfGames
         putStrLn $ "Solved " ++ (show $ length results) ++ " hangman games."
         return ()
      _ -> do 
            pn <- getProgName
            die $ "Usage: " ++ pn ++ " <filename> <wordsLength>"
